/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.Expr;
import ibm.nways.jdm.common.Counter;
import ibm.nways.jdm.common.Counter64;
import ibm.nways.jdm.common.Gauge;
import java.io.Serializable;

class Operator
extends Expr {
    public static final char PLUS = '+';
    public static final char MINUS = '-';
    public static final char TIMES = '*';
    public static final char DIVIDE = '/';
    public static final char EQUAL = '=';
    public static final char GREATER_THAN = '>';
    public static final char LESS_THAN = '<';
    public static final char NOT_EQUAL = 'N';
    public static final char LESS_THAN_OR_EQUAL = 'L';
    public static final char GREATER_THAN_OR_EQUAL = 'G';
    public static final char AND = 'A';
    public static final char OR = 'O';
    public char op;
    Expr operand1;
    Expr operand2;
    boolean isLogicalOp;

    public Operator(char[] cArray, int n, int n2, Expr expr, Expr expr2) {
        char c = cArray[n];
        if (n2 == 1) {
            this.op = c;
            switch (c) {
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    this.isLogicalOp = false;
                    break;
                }
                default: {
                    this.isLogicalOp = true;
                    break;
                }
            }
        } else {
            this.isLogicalOp = true;
            switch (c) {
                case '<': {
                    this.op = (char)76;
                    break;
                }
                case '>': {
                    this.op = (char)71;
                    break;
                }
                case '!': {
                    this.op = (char)78;
                    break;
                }
                case '&': {
                    this.op = (char)65;
                    break;
                }
                case '|': {
                    this.op = (char)79;
                    break;
                }
                case '=': {
                    this.op = (char)61;
                    break;
                }
            }
        }
        this.operand1 = expr;
        this.operand2 = expr2;
    }

    public boolean lowerPriority(char c) {
        return !(this.op != '+' && this.op != '-' || c != '*' && c != '/');
    }

    public Serializable Evaluate(Object[] objectArray, Object[] objectArray2, long l, long l2) {
        Serializable serializable = this.operand1.Evaluate(objectArray, objectArray2, l, l2);
        Serializable serializable2 = this.operand2.Evaluate(objectArray, objectArray2, l, l2);
        if (serializable == null || serializable2 == null) {
            return null;
        }
        if (serializable instanceof String && serializable2 instanceof String) {
            if (this.op == '+') {
                return new String(String.valueOf(serializable.toString()) + serializable2.toString());
            }
            if (this.op == '-') {
                return null;
            }
            if (this.op == '*') {
                return null;
            }
            if (this.op == '/') {
                return null;
            }
            if (this.op == '=') {
                return new Boolean(serializable.equals(serializable2));
            }
            if (this.op == 'N') {
                return new Boolean(!serializable.equals(serializable2));
            }
            if (this.op == '>') {
                return null;
            }
            if (this.op == '<') {
                return null;
            }
            if (this.op == 'L') {
                return null;
            }
            if (this.op == 'G') {
                return null;
            }
            DpInterfaceImpl.LogMessage("unknown binary operator encountered : " + this.op);
            return null;
        }
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        if (serializable instanceof Float) {
            f = ((Float)serializable).floatValue();
        } else if (serializable instanceof Counter) {
            f = ((Counter)serializable).value;
        } else if (serializable instanceof Gauge) {
            f = ((Gauge)serializable).value;
        } else if (serializable instanceof Integer) {
            f = ((Integer)serializable).floatValue();
        } else if (serializable instanceof Counter64) {
            f = ((Counter64)serializable).value;
        }
        if (serializable2 instanceof Float) {
            f2 = ((Float)serializable2).floatValue();
        } else if (serializable2 instanceof Counter) {
            f2 = ((Counter)serializable2).value;
        } else if (serializable2 instanceof Gauge) {
            f2 = ((Gauge)serializable2).value;
        } else if (serializable2 instanceof Integer) {
            f2 = ((Integer)serializable2).floatValue();
        } else if (serializable2 instanceof Counter64) {
            f2 = ((Counter64)serializable2).value;
        }
        if (f == Float.NEGATIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            if (this.isLogicalOp) {
                if (serializable instanceof Boolean && serializable2 instanceof Boolean) {
                    if (this.op == 'A') {
                        return new Boolean((Boolean)serializable != false && (Boolean)serializable2 != false);
                    }
                    if (this.op == 'O') {
                        return new Boolean((Boolean)serializable != false || (Boolean)serializable2 != false);
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        if (this.op == '+') {
            return new Float(f + f2);
        }
        if (this.op == '-') {
            return new Float(f - f2);
        }
        if (this.op == '*') {
            return new Float(f * f2);
        }
        if (this.op == '/') {
            if (f2 == 0.0f) {
                return null;
            }
            return new Float(f / f2);
        }
        if (this.op == '=') {
            return new Boolean(f == f2);
        }
        if (this.op == 'N') {
            return new Boolean(f != f2);
        }
        if (this.op == '>') {
            return new Boolean(f > f2);
        }
        if (this.op == '<') {
            return new Boolean(f < f2);
        }
        if (this.op == 'L') {
            return new Boolean(f <= f2);
        }
        if (this.op == 'G') {
            return new Boolean(f >= f2);
        }
        DpInterfaceImpl.LogMessage("unknown binary operator encountered : " + this.op);
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.operand1);
        switch (this.op) {
            case '=': {
                stringBuffer.append(" == ");
                break;
            }
            case 'N': {
                stringBuffer.append(" != ");
                break;
            }
            case 'L': {
                stringBuffer.append(" <= ");
                break;
            }
            case 'G': {
                stringBuffer.append(" >= ");
                break;
            }
            case 'A': {
                stringBuffer.append(" && ");
                break;
            }
            case 'O': {
                stringBuffer.append(" || ");
                break;
            }
            default: {
                stringBuffer.append(this.op);
            }
        }
        stringBuffer.append(this.operand2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

